/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.action;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.util.FormattingServiceUtil;
import org.cxbox.intellij.community.common.util.JsonElementGenerator;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.jetbrains.annotations.NotNull;

public class SortViewWidgetsByPositionWithStep10Action
extends DumbAwareAction {
    public SortViewWidgetsByPositionWithStep10Action(Icon icon) {
        super(icon);
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SortViewWidgetsByPositionWithStep10Action.$$$reportNull$$$0(0);
        }
        boolean enabled = false;
        boolean paths = false;
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && FileDocumentManager.getInstance().getFile(editor.getDocument()) != null) {
            enabled = true;
        }
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
        e.getPresentation().setText("Sort by Position with Step 10");
        if (paths) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        EditorEx editorex;
        if (e == null) {
            SortViewWidgetsByPositionWithStep10Action.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        e.getPresentation().setText("Sort");
        VirtualFile vf = editor == null ? null : FileDocumentManager.getInstance().getFile(editor.getDocument());
        PsiFile file = PsiManager.getInstance((Project)project).findFile(vf);
        Pair<JsonArray, List<JsonObject>> allViewWidgets = JView.getAllViewWidgets((JsonFile)file);
        List widgetsItems = (List)allViewWidgets.getSecond();
        JsonArray widgets = (JsonArray)allViewWidgets.getFirst();
        List sorted = widgetsItems.stream().sorted(Comparator.comparing(widget -> JView.getViewWidgetPosition(widget).orElse(0.0))).collect(Collectors.toList());
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(vf);
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        if (!widgetsItems.isEmpty()) {
            CommandProcessor.getInstance().executeCommand(project, () -> this.run(project, editor.getDocument(), widgets, sorted), "", null);
        }
        if ((editorex = EditorUtil.getEditorEx((FileEditor)fileEditor)) != null) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
        e.getPresentation().setVisible(file != null && JsonUtil.isJsonFile((VirtualFile)vf, (Project)editor.getProject()));
    }

    public void run(Project project, Document document, JsonArray widgetsItems, List<JsonObject> sorted) {
        ApplicationManager.getApplication().runWriteAction(() -> VcsFacade.getInstance().runHeavyModificationTask(project, document, () -> {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            for (int i = 0; i < sorted.size(); ++i) {
                JsonObject widget = (JsonObject)sorted.get(i);
                int positionWithStep10 = i * 10;
                JsonNumberLiteral position = JsonFacade.safeGetPropertyValueOfType(widget, JView.WIDGETS_WIDGET_POSITION);
                position.replace((PsiElement)new JsonElementGenerator(project).createValue(String.valueOf(positionWithStep10)));
            }
            JsonArray sortedArray = new JsonElementGenerator(project).createArrayOfObjects(sorted.stream().map(PsiElement::getText).collect(Collectors.toList()));
            widgetsItems.replace((PsiElement)sortedArray);
            FormattingServiceUtil.formatElement((PsiElement)sortedArray, false);
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/cxbox/intellij/community/action/SortViewWidgetsByPositionWithStep10Action";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

