/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.options.actionGroups.action.generator;

import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.BcUtil;
import org.cxbox.intellij.community.common.util.EnumBcUtil;
import org.cxbox.intellij.community.common.util.JavaFacade;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.fields.field.generator.common.TemplatesKt;
import org.cxbox.intellij.community.wigdet.options.actionGroups.action.StandardActionType;
import org.cxbox.intellij.community.wigdet.options.actionGroups.action.generator.ActionGeneratorBase;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 X2\u00020\u0001:\u0001XB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010S\u001a\u00020T2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010U\u001a\u00020\u0005H\u0002J\b\u0010V\u001a\u00020\u0019H\u0002J\b\u0010W\u001a\u00020TH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020+X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010-\"\u0004\b=\u0010/R\u001a\u0010>\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u00108\"\u0004\b@\u0010:R\u001a\u0010A\u001a\u00020+X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010-\"\u0004\bC\u0010/R\u001a\u0010D\u001a\u00020EX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020KX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u001a\u0010P\u001a\u00020KX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010M\"\u0004\bR\u0010O\u00a8\u0006Y"}, d2={"Lorg/cxbox/intellij/community/wigdet/options/actionGroups/action/generator/ActionGeneratorBase;", "", "prj", "Lcom/intellij/openapi/project/Project;", "tagValue", "Lcom/intellij/json/psi/JsonStringLiteral;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/json/psi/JsonStringLiteral;)V", "getPrj", "()Lcom/intellij/openapi/project/Project;", "setPrj", "(Lcom/intellij/openapi/project/Project;)V", "instance", "Lcom/intellij/psi/codeStyle/JavaCodeStyleManager;", "getInstance", "()Lcom/intellij/psi/codeStyle/JavaCodeStyleManager;", "setInstance", "(Lcom/intellij/psi/codeStyle/JavaCodeStyleManager;)V", "serviceElementFactory", "Lcom/intellij/psi/PsiElementFactory;", "getServiceElementFactory", "()Lcom/intellij/psi/PsiElementFactory;", "setServiceElementFactory", "(Lcom/intellij/psi/PsiElementFactory;)V", "getActionsPsiMethod", "Lcom/intellij/psi/PsiMethod;", "getGetActionsPsiMethod", "()Lcom/intellij/psi/PsiMethod;", "setGetActionsPsiMethod", "(Lcom/intellij/psi/PsiMethod;)V", "scp", "Lcom/intellij/psi/search/GlobalSearchScope;", "getScp", "()Lcom/intellij/psi/search/GlobalSearchScope;", "setScp", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "()Lcom/intellij/openapi/module/Module;", "setModule", "(Lcom/intellij/openapi/module/Module;)V", "pkg", "", "getPkg", "()Ljava/lang/String;", "setPkg", "(Ljava/lang/String;)V", "keyProp", "Lcom/intellij/json/psi/JsonProperty;", "getKeyProp", "()Lcom/intellij/json/psi/JsonProperty;", "setKeyProp", "(Lcom/intellij/json/psi/JsonProperty;)V", "actionLiteral", "getActionLiteral", "()Lcom/intellij/json/psi/JsonStringLiteral;", "setActionLiteral", "(Lcom/intellij/json/psi/JsonStringLiteral;)V", "actionNameCleaned", "getActionNameCleaned", "setActionNameCleaned", "bcJsonStringLiteral", "getBcJsonStringLiteral", "setBcJsonStringLiteral", "bc", "getBc", "setBc", "bcPsiElement", "Lcom/intellij/psi/PsiEnumConstant;", "getBcPsiElement", "()Lcom/intellij/psi/PsiEnumConstant;", "setBcPsiElement", "(Lcom/intellij/psi/PsiEnumConstant;)V", "bcEnumServiceClass", "Lcom/intellij/psi/PsiClass;", "getBcEnumServiceClass", "()Lcom/intellij/psi/PsiClass;", "setBcEnumServiceClass", "(Lcom/intellij/psi/PsiClass;)V", "dtoPsiClz", "getDtoPsiClz", "setDtoPsiClz", "initAndValidate", "", "keyValue", "getActionMethod", "genGetActionsMethod", "Companion", "cxbox-intellij-plugin"})
public abstract class ActionGeneratorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Project prj;
    public JavaCodeStyleManager instance;
    public PsiElementFactory serviceElementFactory;
    public PsiMethod getActionsPsiMethod;
    public GlobalSearchScope scp;
    public Module module;
    public String pkg;
    public JsonProperty keyProp;
    public JsonStringLiteral actionLiteral;
    public String actionNameCleaned;
    public JsonStringLiteral bcJsonStringLiteral;
    public String bc;
    public PsiEnumConstant bcPsiElement;
    public PsiClass bcEnumServiceClass;
    public PsiClass dtoPsiClz;
    @NotNull
    private static final Map<String, String> standardLambdaStyleAction;
    @NotNull
    private static final Map<String, String> standardOldStyleAction;

    public ActionGeneratorBase(@NotNull Project prj, @NotNull JsonStringLiteral tagValue) {
        Intrinsics.checkNotNullParameter((Object)prj, (String)"prj");
        Intrinsics.checkNotNullParameter((Object)tagValue, (String)"tagValue");
        this.prj = prj;
        this.initAndValidate(this.prj, tagValue);
    }

    @NotNull
    public final Project getPrj() {
        return this.prj;
    }

    public final void setPrj(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.prj = project;
    }

    @NotNull
    public final JavaCodeStyleManager getInstance() {
        JavaCodeStyleManager javaCodeStyleManager = this.instance;
        if (javaCodeStyleManager != null) {
            return javaCodeStyleManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
        return null;
    }

    public final void setInstance(@NotNull JavaCodeStyleManager javaCodeStyleManager) {
        Intrinsics.checkNotNullParameter((Object)javaCodeStyleManager, (String)"<set-?>");
        this.instance = javaCodeStyleManager;
    }

    @NotNull
    public final PsiElementFactory getServiceElementFactory() {
        PsiElementFactory psiElementFactory = this.serviceElementFactory;
        if (psiElementFactory != null) {
            return psiElementFactory;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"serviceElementFactory");
        return null;
    }

    public final void setServiceElementFactory(@NotNull PsiElementFactory psiElementFactory) {
        Intrinsics.checkNotNullParameter((Object)psiElementFactory, (String)"<set-?>");
        this.serviceElementFactory = psiElementFactory;
    }

    @NotNull
    public final PsiMethod getGetActionsPsiMethod() {
        PsiMethod psiMethod = this.getActionsPsiMethod;
        if (psiMethod != null) {
            return psiMethod;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"getActionsPsiMethod");
        return null;
    }

    public final void setGetActionsPsiMethod(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"<set-?>");
        this.getActionsPsiMethod = psiMethod;
    }

    @NotNull
    public final GlobalSearchScope getScp() {
        GlobalSearchScope globalSearchScope = this.scp;
        if (globalSearchScope != null) {
            return globalSearchScope;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scp");
        return null;
    }

    public final void setScp(@NotNull GlobalSearchScope globalSearchScope) {
        Intrinsics.checkNotNullParameter((Object)globalSearchScope, (String)"<set-?>");
        this.scp = globalSearchScope;
    }

    @NotNull
    public final Module getModule() {
        Module module = this.module;
        if (module != null) {
            return module;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"module");
        return null;
    }

    public final void setModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"<set-?>");
        this.module = module;
    }

    @NotNull
    public final String getPkg() {
        String string = this.pkg;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"pkg");
        return null;
    }

    public final void setPkg(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.pkg = string;
    }

    @NotNull
    public final JsonProperty getKeyProp() {
        JsonProperty jsonProperty = this.keyProp;
        if (jsonProperty != null) {
            return jsonProperty;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keyProp");
        return null;
    }

    public final void setKeyProp(@NotNull JsonProperty jsonProperty) {
        Intrinsics.checkNotNullParameter((Object)jsonProperty, (String)"<set-?>");
        this.keyProp = jsonProperty;
    }

    @NotNull
    public final JsonStringLiteral getActionLiteral() {
        JsonStringLiteral jsonStringLiteral = this.actionLiteral;
        if (jsonStringLiteral != null) {
            return jsonStringLiteral;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"actionLiteral");
        return null;
    }

    public final void setActionLiteral(@NotNull JsonStringLiteral jsonStringLiteral) {
        Intrinsics.checkNotNullParameter((Object)jsonStringLiteral, (String)"<set-?>");
        this.actionLiteral = jsonStringLiteral;
    }

    @NotNull
    public final String getActionNameCleaned() {
        String string = this.actionNameCleaned;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"actionNameCleaned");
        return null;
    }

    public final void setActionNameCleaned(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.actionNameCleaned = string;
    }

    @NotNull
    public final JsonStringLiteral getBcJsonStringLiteral() {
        JsonStringLiteral jsonStringLiteral = this.bcJsonStringLiteral;
        if (jsonStringLiteral != null) {
            return jsonStringLiteral;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bcJsonStringLiteral");
        return null;
    }

    public final void setBcJsonStringLiteral(@NotNull JsonStringLiteral jsonStringLiteral) {
        Intrinsics.checkNotNullParameter((Object)jsonStringLiteral, (String)"<set-?>");
        this.bcJsonStringLiteral = jsonStringLiteral;
    }

    @NotNull
    public final String getBc() {
        String string = this.bc;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bc");
        return null;
    }

    public final void setBc(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.bc = string;
    }

    @NotNull
    public final PsiEnumConstant getBcPsiElement() {
        PsiEnumConstant psiEnumConstant = this.bcPsiElement;
        if (psiEnumConstant != null) {
            return psiEnumConstant;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bcPsiElement");
        return null;
    }

    public final void setBcPsiElement(@NotNull PsiEnumConstant psiEnumConstant) {
        Intrinsics.checkNotNullParameter((Object)psiEnumConstant, (String)"<set-?>");
        this.bcPsiElement = psiEnumConstant;
    }

    @NotNull
    public final PsiClass getBcEnumServiceClass() {
        PsiClass psiClass = this.bcEnumServiceClass;
        if (psiClass != null) {
            return psiClass;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bcEnumServiceClass");
        return null;
    }

    public final void setBcEnumServiceClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"<set-?>");
        this.bcEnumServiceClass = psiClass;
    }

    @NotNull
    public final PsiClass getDtoPsiClz() {
        PsiClass psiClass = this.dtoPsiClz;
        if (psiClass != null) {
            return psiClass;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dtoPsiClz");
        return null;
    }

    public final void setDtoPsiClz(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"<set-?>");
        this.dtoPsiClz = psiClass;
    }

    private final void initAndValidate(Project prj, JsonStringLiteral keyValue) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)keyValue));
        if (module == null) {
            throw new PlatformValidationException("cannot determine project module for <a href=\"1\">key</a>", (NavigatablePsiElement)keyValue, prj);
        }
        this.setModule(module);
        this.setPkg(Cache.getPlatformRootPackageWithoutDot(prj, this.getModule()));
        JsonProperty jsonProperty = JsonFacade.getParentOfType((PsiElement)keyValue, JsonProperty.class);
        if (jsonProperty == null) {
            throw new PlatformValidationException("<a href=\"1\">key</a> must belong to a valid json property", (NavigatablePsiElement)keyValue, prj);
        }
        this.setKeyProp(jsonProperty);
        this.setActionLiteral(keyValue);
        this.setActionNameCleaned(JavaFacade.toUrlParamFriendly(JsonFacade.getValue(keyValue)));
        if (StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)this.getActionNameCleaned())).toString())) {
            throw new PlatformValidationException("<a href=\"1\">key</a> must not be empty, but was key = \"" + JsonFacade.getValue(keyValue) + "\" <=> \"\" (after clean up from chars, that need URLEncoding)", (NavigatablePsiElement)keyValue, prj);
        }
        JsonStringLiteral jsonStringLiteral = BcUtil.getNearestBc((JsonElement)this.getKeyProp());
        if (jsonStringLiteral == null) {
            throw new PlatformValidationException("cannot determine bc tag or value for <a href=\"1\">key</a> in current widget", (NavigatablePsiElement)this.getKeyProp(), prj);
        }
        this.setBcJsonStringLiteral(jsonStringLiteral);
        this.setBc(JsonFacade.getValue(this.getBcJsonStringLiteral()));
        if (StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)this.getBc())).toString())) {
            throw new PlatformValidationException("widget <a href=\"1\">bc</a> must not be empty, but was bc = \"" + this.getBc(), (NavigatablePsiElement)this.getBcJsonStringLiteral(), prj);
        }
        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)EnumBcUtil.getLinkAndAutocompletionByBc(this.getBc(), prj, this.getModule()).getFirst();
        if (psiEnumConstant == null) {
            throw new PlatformValidationException("cannot determine enum where <a href=\"1\">bc</a> = " + this.getBc() + " is defined", (NavigatablePsiElement)this.getBcJsonStringLiteral(), prj);
        }
        this.setBcPsiElement(psiEnumConstant);
        PsiClass psiClass = EnumBcUtil.getBcServiceClass(this.getBcPsiElement(), prj, this.getModule());
        if (psiClass == null) {
            PsiClass psiClass2 = this.getBcPsiElement().getContainingClass();
            throw new PlatformValidationException("cannot determine Service class for <a href=\"1\">bc</a> = " + this.getBc() + " in enum = " + (psiClass2 != null ? psiClass2.getQualifiedName() : null), (NavigatablePsiElement)this.getBcPsiElement(), prj);
        }
        this.setBcEnumServiceClass(psiClass);
        PsiClass psiClass3 = EnumBcUtil.getBcServiceDtoClass(this.getBcEnumServiceClass(), prj, this.getModule());
        if (psiClass3 == null) {
            PsiClass psiClass4 = this.getBcPsiElement().getContainingClass();
            throw new PlatformValidationException("cannot determine Dto of <a href=\"1\">Service class</a> = " + this.getBcEnumServiceClass().getQualifiedName() + " for bc = " + this.getBc() + " defined in enum = " + (psiClass4 != null ? psiClass4.getQualifiedName() : null), (NavigatablePsiElement)this.getBcEnumServiceClass(), prj);
        }
        this.setDtoPsiClz(psiClass3);
        this.setScp(SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(this.getModule(), prj));
        this.setInstance(JavaCodeStyleManager.getInstance((Project)this.getBcEnumServiceClass().getProject()));
        this.setServiceElementFactory(JavaPsiFacade.getElementFactory((Project)prj));
        this.setGetActionsPsiMethod(this.getActionMethod());
    }

    private final PsiMethod getActionMethod() {
        Optional<Object> actionMethod2 = Optional.of(this.getBcEnumServiceClass().getMethods()).stream().flatMap(arg_0 -> ActionGeneratorBase.getActionMethod$lambda$0(getActionMethod.actionMethod.1.INSTANCE, arg_0)).filter(arg_0 -> ActionGeneratorBase.getActionMethod$lambda$2(ActionGeneratorBase::getActionMethod$lambda$1, arg_0)).findFirst();
        if (actionMethod2.isPresent()) {
            Object object = actionMethod2.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (PsiMethod)object;
        }
        this.genGetActionsMethod();
        Object object = Optional.of(this.getBcEnumServiceClass().getMethods()).stream().flatMap(arg_0 -> ActionGeneratorBase.getActionMethod$lambda$3(getActionMethod.1.INSTANCE, arg_0)).filter(arg_0 -> ActionGeneratorBase.getActionMethod$lambda$5(ActionGeneratorBase::getActionMethod$lambda$4, arg_0)).findFirst().orElseThrow(() -> ActionGeneratorBase.getActionMethod$lambda$6(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"orElseThrow(...)");
        return (PsiMethod)object;
    }

    private final void genGetActionsMethod() {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.prj);
        PsiMethod psiMethod = factory.createMethodFromText(TemplatesKt.getNewActionMethod(this.getDtoPsiClz(), this.getPkg()), (PsiElement)this.getBcEnumServiceClass());
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"createMethodFromText(...)");
        PsiMethod method = psiMethod;
        this.getBcEnumServiceClass().add((PsiElement)method);
    }

    private static final Stream getActionMethod$lambda$0(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final boolean getActionMethod$lambda$1(PsiMethod it) {
        return Intrinsics.areEqual((Object)"getActions", (Object)it.getName());
    }

    private static final boolean getActionMethod$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Stream getActionMethod$lambda$3(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final boolean getActionMethod$lambda$4(PsiMethod it) {
        return Intrinsics.areEqual((Object)"getActions", (Object)it.getName());
    }

    private static final boolean getActionMethod$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final PlatformValidationException getActionMethod$lambda$6(ActionGeneratorBase this$0) {
        PsiClass psiClass = this$0.getBcPsiElement().getContainingClass();
        return new PlatformValidationException("cannot determine getActions() method in <a href=\"1\">" + this$0.getBcEnumServiceClass().getName() + "</a> (bc = " + this$0.getBc() + ", enum = " + (psiClass != null ? psiClass.getQualifiedName() : null) + ")", (NavigatablePsiElement)this$0.getBcEnumServiceClass(), this$0.prj);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)StandardActionType.SAVE.key, (Object)".save(sv -> sv.text(\"Save\"))\n"), TuplesKt.to((Object)StandardActionType.CREATE.key, (Object)".create(crt -> crt.text(\"Create\"))\n"), TuplesKt.to((Object)StandardActionType.DELETE.key, (Object)".delete(dlt -> dlt.text(\"Delete\"))\n"), TuplesKt.to((Object)StandardActionType.CANCEL_CREATE.key, (Object)".cancelCreate(ccr -> ccr.text(\"Cancel\"))\n"), TuplesKt.to((Object)StandardActionType.ASSOCIATE.key, (Object)".associate(assoc -> assoc.text(\"Associate\"))\n")};
        standardLambdaStyleAction = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)StandardActionType.SAVE.key, (Object)".save().text(\"Save\").add()\n"), TuplesKt.to((Object)StandardActionType.CREATE.key, (Object)".create().text(\"Create\").add()\n"), TuplesKt.to((Object)StandardActionType.DELETE.key, (Object)".delete().text(\"Delete\").add()\n"), TuplesKt.to((Object)StandardActionType.CANCEL_CREATE.key, (Object)".cancelCreate().text(\"Cancel\").add()\n"), TuplesKt.to((Object)StandardActionType.ASSOCIATE.key, (Object)".associate().text(\"Associate\").add()\n")};
        standardOldStyleAction = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R%\u0010\u0004\u001a\u0016\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR%\u0010\n\u001a\u0016\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/cxbox/intellij/community/wigdet/options/actionGroups/action/generator/ActionGeneratorBase$Companion;", "", "<init>", "()V", "standardLambdaStyleAction", "", "", "kotlin.jvm.PlatformType", "getStandardLambdaStyleAction", "()Ljava/util/Map;", "standardOldStyleAction", "getStandardOldStyleAction", "cxbox-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getStandardLambdaStyleAction() {
            return standardLambdaStyleAction;
        }

        @NotNull
        public final Map<String, String> getStandardOldStyleAction() {
            return standardOldStyleAction;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

