/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.BalloonUtil;
import org.cxbox.intellij.community.common.util.BcUtil;
import org.cxbox.intellij.community.common.util.CompileUtils;
import org.cxbox.intellij.community.common.util.DtoMetaModelUtil;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.PsiIndexSynchronizer;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.exception.InternalErrorPlatformException;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.bc.BCReferenceContributor;
import org.cxbox.intellij.community.wigdet.bc.common.ResponseServiceType;
import org.cxbox.intellij.community.wigdet.bc.service.BcServiceGeneratorHolder;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ElementGenerationContext;
import org.cxbox.intellij.community.wigdet.bc.ui.BcCreationDialogWrapper;
import org.jetbrains.annotations.NotNull;

public final class BCInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "BCInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            BCInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            BCInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = file.getProject();
        SmartList descriptors = new SmartList();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Arrays.stream(file.getChildren()).filter(Objects::nonNull).forEach(arg_0 -> this.lambda$checkFile$0(manager, (List)descriptors, project, module, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void extracted(@NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> descriptors, @NotNull PsiElement c, @NotNull Project project, @NotNull Module module) {
        if (manager == null) {
            BCInspection.$$$reportNull$$$0(2);
        }
        if (descriptors == null) {
            BCInspection.$$$reportNull$$$0(3);
        }
        if (c == null) {
            BCInspection.$$$reportNull$$$0(4);
        }
        if (project == null) {
            BCInspection.$$$reportNull$$$0(5);
        }
        if (module == null) {
            BCInspection.$$$reportNull$$$0(6);
        }
        if (BCReferenceContributor.Holder.WIDGET_BC_REF_PATTERN.accepts((Object)c)) {
            String value = JsonFacade.safeGetValueAsString(c);
            Optional link = (Optional)BcUtil.getLinkAndAutocompletionByBc(value, project, module).getFirst();
            if (link.isEmpty()) {
                descriptors.add(manager.createProblemDescriptor(c, value == null ? new TextRange(0, c.getText().length()) : new TextRange(1, value.length() + 1), "Bc not found. Incorrect value. Use autocomplete to provide correct one", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true, new LocalQuickFix[]{new Fix(value == null), new FixWithCreationBc()}));
            }
        } else {
            Arrays.stream(c.getChildren()).forEach(c2 -> this.extracted(manager, descriptors, (PsiElement)c2, project, module));
        }
    }

    private /* synthetic */ void lambda$checkFile$0(InspectionManager manager, List descriptors, Project project, Module module, PsiElement c) {
        this.extracted(manager, descriptors, c, project, module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/wigdet/bc/BCInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "extracted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Fix
    implements LocalQuickFix {
        private boolean valueIsNull;

        public Fix(boolean valueIsNull) {
            this.valueIsNull = valueIsNull;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Select correct value";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Select correct value";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            if (this.valueIsNull) {
                QuickFixUtils.changeNullToEmptyJsonStringLiteralValueAndInvokeAutoCompliteIfPossible(project, descriptor.getPsiElement());
            } else {
                QuickFixUtils.clearJsonStringLiteralValueAndInvokeAutoCompliteIfPossible(project, descriptor.getPsiElement());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/wigdet/bc/BCInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class FixWithCreationBc
    implements LocalQuickFix {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                FixWithCreationBc.$$$reportNull$$$0(0);
            }
            if (previewDescriptor == null) {
                FixWithCreationBc.$$$reportNull$$$0(1);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                FixWithCreationBc.$$$reportNull$$$0(2);
            }
            return intentionPreviewInfo;
        }

        @NotNull
        public String getName() {
            return "Create new bc";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Create new bc";
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                FixWithCreationBc.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                FixWithCreationBc.$$$reportNull$$$0(4);
            }
            Boolean isException = false;
            final PsiElement psiElement = descriptor.getPsiElement();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Preparing bc creation", true){

                public void run(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    BcCreationMetaData bcCreationMetaData = this.collectDialogData(project, psiElement, indicator);
                    ApplicationManager.getApplication().invokeLater(() -> this.showDialogAndCreateClasses(project, bcCreationMetaData));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/cxbox/intellij/community/wigdet/bc/BCInspection$FixWithCreationBc$1", "run"));
                }
            });
        }

        private void showDialogAndCreateClasses(final Project project, final BcCreationMetaData data) {
            final BcCreationDialogWrapper completionDialog = new BcCreationDialogWrapper(project, data.module, data.value, data);
            if (completionDialog.showAndGet()) {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                FileDocumentManager.getInstance().saveAllDocuments();
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Start creating bc"){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        try {
                            boolean bcIsAnySource;
                            boolean parentBcIsAnySource;
                            DumbService.getInstance((Project)project).waitForSmartMode();
                            ElementGenerationContext.ElementBcData elementBcData = BcServiceGeneratorHolder.create(data.module(), completionDialog.getValues(), data);
                            if (elementBcData.parentBcEnum() != null) {
                                ResponseServiceUtils.ResponseServiceData parentResponseServiceDataByBc = (ResponseServiceUtils.ResponseServiceData)ApplicationManager.getApplication().runReadAction(() -> ResponseServiceUtils.getResponseServiceDataByBc(project, data.module(), elementBcData.parentBcEnum()));
                                parentBcIsAnySource = (Boolean)ApplicationManager.getApplication().runReadAction(() -> ResponseServiceUtils.isAnySourceVersionAwareResponseService(parentResponseServiceDataByBc.responseServicePsiClass(), project, data.module()));
                                bcIsAnySource = (Boolean)ApplicationManager.getApplication().runReadAction(() -> ResponseServiceUtils.isAnySourceVersionAwareResponseService(elementBcData.serviceClz(), project, data.module()));
                            } else {
                                Object parentResponseServiceDataByBc = null;
                                parentBcIsAnySource = false;
                                bcIsAnySource = false;
                            }
                            ApplicationManager.getApplication().invokeLater(() -> {
                                this.psiRefresh(elementBcData, data.module().getProject());
                                int result = this.showBuildMessage(data.module(), elementBcData);
                                this.showBallonMessage(project, data, elementBcData, result, parentBcIsAnySource, bcIsAnySource);
                            });
                        }
                        catch (PlatformValidationException e) {
                            ApplicationManager.getApplication().invokeLater(e::showPopupWithLinks);
                        }
                        catch (Exception e) {
                            ApplicationManager.getApplication().invokeLater(() -> new InternalErrorPlatformException("Generation not available! Please contact with administrator", null, e, project).showPopupWithLinks());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/cxbox/intellij/community/wigdet/bc/BCInspection$FixWithCreationBc$2", "run"));
                    }
                });
            }
        }

        private BcCreationMetaData collectDialogData(Project project, PsiElement psiElement, ProgressIndicator indicator) {
            return (BcCreationMetaData)ApplicationManager.getApplication().runReadAction(() -> {
                indicator.checkCanceled();
                indicator.setText("Search navigatable elements");
                NavigatablePsiElement navigatable = JavaUtil.getNavigatableElement(psiElement);
                indicator.setText("Search module");
                Module module = this.findModule(psiElement, navigatable);
                indicator.setText("Getting bc value");
                String value = this.getJsonValue(psiElement);
                indicator.checkCanceled();
                indicator.setText("Collect services for suggestion");
                FieldsSuggestionData fieldsSuggestionData = this.collectFieldSuggestions(project, module);
                indicator.checkCanceled();
                return new BcCreationMetaData(module, value, navigatable, fieldsSuggestionData);
            });
        }

        private Module findModule(PsiElement psiElement, NavigatablePsiElement navigatable) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                throw new PlatformValidationException("Cannot find module", navigatable, psiElement.getProject());
            }
            return module;
        }

        private String getJsonValue(PsiElement psiElement) {
            if (!(psiElement instanceof JsonStringLiteral)) {
                throw new PlatformValidationException("Cannot read bc name", JavaUtil.getNavigatableElement(psiElement), psiElement.getProject());
            }
            JsonStringLiteral literal = (JsonStringLiteral)psiElement;
            return JsonFacade.getValue(literal);
        }

        private FieldsSuggestionData collectFieldSuggestions(Project project, Module module) {
            return new FieldsSuggestionData(ResponseServiceUtils.getAllResponseServiceData(module.getProject(), module).stream().map(ResponseServiceUtils.ResponseServiceData::responseServicePsiClass).filter(psc -> !psc.hasModifierProperty("abstract")).filter(psc -> Optional.of(psc).map(PsiClass::getQualifiedName).isPresent()).filter(bcEnumServiceClass -> ResponseServiceUtils.isAnySourceResponseServiceImplFromServiceClass(bcEnumServiceClass, module.getProject(), module)).collect(Collectors.toSet()), ResponseServiceUtils.getAllResponseServiceData(project, module).stream().map(ResponseServiceUtils.ResponseServiceData::responseServiceDtoPsiClass).filter(psc -> !psc.hasModifierProperty("abstract")).filter(psc -> Optional.of(psc).map(PsiClass::getQualifiedName).isPresent()).collect(Collectors.toSet()), ResponseServiceUtils.getAllResponseServiceData(project, module).stream().map(ResponseServiceUtils.ResponseServiceData::responseServiceEntityPsiClass).filter(psc -> !psc.hasModifierProperty("abstract")).filter(psc -> Optional.of(psc).map(PsiClass::getQualifiedName).isPresent()).collect(Collectors.toSet()), ResponseServiceUtils.getAllResponseServiceData(module.getProject(), module).stream().map(ResponseServiceUtils.ResponseServiceData::responseServicePsiClass).filter(psc -> !psc.hasModifierProperty("abstract")).filter(psc -> Optional.of(psc).map(PsiClass::getQualifiedName).isPresent()).filter(bcEnumServiceClass -> ResponseServiceUtils.isVersionAwareResponseServiceImplFromServiceClass(bcEnumServiceClass, module.getProject(), module)).collect(Collectors.toSet()), (Collection<ResponseServiceType>)Optional.ofNullable(Cache.getAnySourceServiceClass(project, module)).map(s -> ResponseServiceType.values()).map(Arrays::asList).orElse(List.of(ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE)));
        }

        private void psiRefresh(ElementGenerationContext.ElementBcData elementBcData, Project project) {
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            Optional.of(elementBcData).map(ElementGenerationContext.ElementBcData::bcEnum).map(PsiElement::getContainingFile).map(PsiFile::getVirtualFile).ifPresent(files::add);
            Optional.of(elementBcData).map(ElementGenerationContext.ElementBcData::entityClz).map(PsiElement::getContainingFile).map(PsiFile::getVirtualFile).ifPresent(files::add);
            Optional.of(elementBcData).map(ElementGenerationContext.ElementBcData::dtoClz).map(PsiElement::getContainingFile).map(PsiFile::getVirtualFile).ifPresent(files::add);
            Optional.of(elementBcData).map(ElementGenerationContext.ElementBcData::serviceClz).map(PsiElement::getContainingFile).map(PsiFile::getVirtualFile).ifPresent(files::add);
            Optional.of(elementBcData).map(ElementGenerationContext.ElementBcData::metaClz).map(PsiElement::getContainingFile).map(PsiFile::getVirtualFile).ifPresent(files::add);
            Optional.of(elementBcData).map(ElementGenerationContext.ElementBcData::daoClz).map(PsiElement::getContainingFile).map(PsiFile::getVirtualFile).ifPresent(files::add);
            Optional.of(elementBcData).map(ElementGenerationContext.ElementBcData::repoClz).map(PsiElement::getContainingFile).map(PsiFile::getVirtualFile).ifPresent(files::add);
            Optional.of(elementBcData).map(ElementGenerationContext.ElementBcData::parentEntityClz).map(PsiElement::getContainingFile).map(PsiFile::getVirtualFile).ifPresent(files::add);
            Optional.of(elementBcData).map(ElementGenerationContext.ElementBcData::parentRepoClz).map(PsiElement::getContainingFile).map(PsiFile::getVirtualFile).ifPresent(files::add);
            PsiIndexSynchronizer.synchronizeFile(project, files);
        }

        private void showBallonMessage(Project project, BcCreationMetaData data, ElementGenerationContext.ElementBcData elementBcData, int result, boolean parentBcIsAnySource, boolean bcIsAnySource) {
            String content = "Success! You can " + (result == 0 ? "" : "rebulid and ") + "run application - it will work!";
            HashMap<String, Pair<PsiElement, BiConsumer<Project, PsiElement>>> elements = new HashMap<String, Pair<PsiElement, BiConsumer<Project, PsiElement>>>();
            if (elementBcData.parentBcEnum() != null) {
                if (parentBcIsAnySource && bcIsAnySource) {
                    PsiMethod psiMethodGetList = Arrays.stream(elementBcData.daoClz().getMethods()).filter(m -> m.getName().equals("getList")).findFirst().orElse(null);
                    if (!elementBcData.isNewService()) {
                        Object widgetNameText = "For now current widget";
                        PsiFile psiFile = data.element().getContainingFile();
                        if (psiFile instanceof JsonFile) {
                            JsonFile jsonFile = (JsonFile)psiFile;
                            widgetNameText = "For now widget <a href=\"widget\">" + JWidget.getName(jsonFile) + " </a>";
                            elements.put("widget", (Pair<PsiElement, BiConsumer<Project, PsiElement>>)Pair.create((Object)jsonFile, (prj, elm) -> ApplicationManager.getApplication().invokeLater(() -> {
                                PsiFile psiMethod;
                                if (elm instanceof PsiFile && (psiMethod = (PsiFile)elm).canNavigate()) {
                                    psiMethod.navigate(true);
                                }
                            })));
                        }
                        content = "Success! You can " + (result == 0 ? "" : "rebulid and ") + "run application - it will work!<br/><br/><b><i>Note:</i></b> " + (String)widgetNameText + " will show all records.<br/>To show only linked to parent <a href=\"parentBc\">" + elementBcData.parentBcEnum().getName() + "</a> records - please implement TODO <a href=\"todo\">here</a> <br/>(this is code generation restriction only for 'AnySource' parents)";
                    }
                    elements.put("todo", (Pair<PsiElement, BiConsumer<Project, PsiElement>>)Pair.create((Object)psiMethodGetList, (prj, elm) -> ApplicationManager.getApplication().invokeLater(() -> {
                        PsiMethod psi;
                        if (elm instanceof PsiMethod && (psi = (PsiMethod)elm).canNavigate()) {
                            psi.navigate(true);
                        }
                    })));
                    elements.put("parentBc", (Pair<PsiElement, BiConsumer<Project, PsiElement>>)Pair.create((Object)elementBcData.parentBcEnum(), (prj, elm) -> ApplicationManager.getApplication().invokeLater(() -> {
                        PsiEnumConstant psi;
                        if (elm instanceof PsiEnumConstant && (psi = (PsiEnumConstant)elm).canNavigate()) {
                            psi.navigate(true);
                        }
                    })));
                }
            } else {
                content = "Success! You can " + (result == 0 ? "" : "rebulid and ") + "run application - it will work!";
            }
            BalloonUtil.showSuccessBalloon(project, content, elements);
        }

        private int showBuildMessage(Module module, ElementGenerationContext.ElementBcData elementBcData) {
            int result = Messages.showYesNoDialog((Project)module.getProject(), (String)"Do you want to rebuild ?", (String)"Rebuild project", (Icon)Messages.getQuestionIcon());
            return (Integer)WriteCommandAction.runWriteCommandAction((Project)module.getProject(), () -> {
                if (result == 0) {
                    if (elementBcData.entityClz() != null && elementBcData.dtoClz() != null) {
                        CompileUtils.runCompileWithForcedAnnotationProcessing(module.getProject(), new VirtualFile[]{elementBcData.entityClz().getContainingFile().getVirtualFile(), elementBcData.dtoClz().getContainingFile().getVirtualFile()}, CompileUtils.SIMPLE_LOG_CALLBACK);
                    }
                } else {
                    DtoMetaModelUtil.syncDtoMetaModelClass(elementBcData.dtoClz(), JavaPsiFacade.getInstance((Project)module.getProject()), SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject()));
                }
                this.postFinish(module, elementBcData);
                return result;
            });
        }

        public void postFinish(Module module, ElementGenerationContext.ElementBcData elementBcData) {
            Optional<ElementGenerationContext.ElementBcData> dataOptional = Optional.of(elementBcData);
            dataOptional.map(ElementGenerationContext.ElementBcData::entityClz).map(PsiElement::getContainingFile).ifPresent(this::reformatCode);
            dataOptional.map(ElementGenerationContext.ElementBcData::repoClz).map(PsiElement::getContainingFile).ifPresent(this::reformatCode);
            dataOptional.map(ElementGenerationContext.ElementBcData::dtoClz).map(PsiElement::getContainingFile).ifPresent(this::reformatCode);
            dataOptional.map(ElementGenerationContext.ElementBcData::metaClz).map(PsiElement::getContainingFile).ifPresent(this::reformatCode);
            dataOptional.map(ElementGenerationContext.ElementBcData::daoClz).map(PsiElement::getContainingFile).ifPresent(this::reformatCode);
            dataOptional.map(ElementGenerationContext.ElementBcData::serviceClz).map(PsiElement::getContainingFile).ifPresent(this::reformatCode);
        }

        private void reformatCode(PsiElement element) {
            JavaCodeStyleManager javaStyleManager = JavaCodeStyleManager.getInstance((Project)element.getProject());
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)element.getProject());
            javaStyleManager.shortenClassReferences(element);
            codeStyleManager.reformat(element);
            if (element instanceof PsiFile) {
                PsiFile psiFile = (PsiFile)element;
                javaStyleManager.optimizeImports(psiFile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/wigdet/bc/BCInspection$FixWithCreationBc";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/wigdet/bc/BCInspection$FixWithCreationBc";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        public record BcCreationMetaData(Module module, String value, NavigatablePsiElement element, FieldsSuggestionData fieldsSuggestionData) {
        }

        public record FieldsSuggestionData(Collection<PsiClass> anySourceServices, Collection<PsiClass> dtos, Collection<PsiClass> entities, Collection<PsiClass> versionAwareServices, Collection<ResponseServiceType> types) {
        }
    }
}

