/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.options.layout;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.List;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.jetbrains.annotations.NotNull;

public class SpanSumMoreThanMaxValueInspection
extends LocalInspectionTool {
    public static final int MAX_SUM_SPAN = 24;
    private static final List<String> WIDGETS_TYPE_APPLICABLE = List.of(JWidget.TYPE_VALUE_FORM.getValue(), JWidget.TYPE_VALUE_INFO.getValue());

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpanSumMoreThanMaxValueInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpanSumMoreThanMaxValueInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile jsonFile = (JsonFile)file;
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        String widgetType = JWidget.getWidgetType(jsonFile);
        if (widgetType != null) {
            if (WIDGETS_TYPE_APPLICABLE.stream().noneMatch(widgetType::equals)) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
        }
        SmartList descriptors = new SmartList();
        JsonObject topLevelValue = JsonFacade.getTopLevelObject(jsonFile);
        JsonObject options = JsonFacade.safeGetPropertyValueOfType(topLevelValue, JWidget.OPTIONS);
        JsonObject layout = JsonFacade.safeGetPropertyValueOfType(options, JWidget.LAYOUT);
        JsonArray rows = JsonFacade.safeGetPropertyValueOfType(layout, JWidget.LAYOUT_ROWS);
        if (rows == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        for (JsonValue row : rows.getValueList()) {
            JsonArray cols = JsonFacade.safeGetPropertyValueOfType((JsonObject)row, JWidget.LAYOUT_ROWS_COLS);
            if (cols == null) continue;
            int summSpanOnCols = 0;
            for (JsonValue col : cols.getValueList()) {
                JsonLiteral jsonLiteral = JsonFacade.safeGetPropertyValueOfType((JsonObject)col, JWidget.LAYOUT_ROWS_COLS_SPAN_COMMON);
                if (jsonLiteral instanceof JsonNumberLiteral) {
                    JsonNumberLiteral numberLiteral = (JsonNumberLiteral)jsonLiteral;
                    summSpanOnCols += (int)JsonFacade.getValue(numberLiteral);
                    continue;
                }
                if (!(jsonLiteral instanceof JsonStringLiteral)) continue;
                JsonStringLiteral stringLiteral = (JsonStringLiteral)jsonLiteral;
                summSpanOnCols += Integer.parseInt(JsonFacade.getValue(stringLiteral));
            }
            if (summSpanOnCols <= 24) continue;
            descriptors.add(manager.createProblemDescriptor((PsiElement)file, cols.getParent().getFirstChild().getTextRange(), "'span' sum in 'cols' is more than max value 24", ProblemHighlightType.WARNING, true, new LocalQuickFix[0]));
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/wigdet/options/layout/SpanSumMoreThanMaxValueInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

