/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.javaToMetaRefs.widgetName;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Optional;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.javaToMetaRefs.widgetName.reference.JavaWidgetNameReferenceContributor;
import org.jetbrains.annotations.NotNull;

public class JavaWidgetTypeInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JavaWidgetTypeInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitLiteralExpression(element);
                if (!JavaWidgetNameReferenceContributor.Holder.ANNOTATION_WIDGET_NAME_REF_PATTERN.accepts((Object)element)) {
                    return;
                }
                Project project = element.getProject();
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module == null) {
                    return;
                }
                String value = element.getText().replace("\"", "");
                PsiParameter parameterForArgument = MethodCallUtils.getParameterForArgument((PsiExpression)element);
                if (parameterForArgument == null) {
                    return;
                }
                String typeFamily = Optional.ofNullable(parameterForArgument.getAnnotation(Cache.getPlatformRootPackageWithoutDot(project, module) + ".meta.ui.field.WidgetName")).map(annotation -> annotation.findAttributeValue("typeFamily")).map(psiAnnotationMemberValue -> {
                    PsiReferenceExpression psiReferenceExpression;
                    PsiElement resolve;
                    if (psiAnnotationMemberValue instanceof PsiReferenceExpression && (resolve = (psiReferenceExpression = (PsiReferenceExpression)psiAnnotationMemberValue).resolve()) instanceof PsiEnumConstant) {
                        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)resolve;
                        return JavaUtil.safeGetEnumFirstStringArgument(psiEnumConstant);
                    }
                    return null;
                }).orElse(null);
                if (typeFamily == null) {
                    return;
                }
                String type = JWidget.getWidgetByName(value, SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, project), project, module).map(JWidget::getWidgetType).orElse(null);
                if (type == null || !type.endsWith(typeFamily)) {
                    holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)element, new TextRange(1, value.length() + 1), "The widget has type '" + type + "', that is not from expected type family '" + typeFamily + "'. E.g. type.endsWith(typeFamily) != true", ProblemHighlightType.WARNING, true, new LocalQuickFix[]{new QuickFixUtils.ClearJavaPsiLiteralValueAndCallAutocompletionFix("Select correct value", (PsiElement)element)}));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/cxbox/intellij/community/javaToMetaRefs/widgetName/JavaWidgetTypeInspection$1", "visitLiteralExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/cxbox/intellij/community/javaToMetaRefs/widgetName/JavaWidgetTypeInspection", "buildVisitor"));
    }
}

