/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.action;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.cxbox.intellij.community.common.util.JsonElementGenerator;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunTemplateAction
extends DumbAwareAction {
    private final Template template;
    private final JsonProperty targetFields;

    public RunTemplateAction(Template template, JsonProperty targetFields, Icon icon) {
        super(icon);
        this.targetFields = targetFields;
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
        this.template = template;
    }

    public static <T extends PsiElement> void runTemplate(T psiElement, Editor editor, @Nullable Template template, Map<String, String> predefinedVars, Project project, boolean runInSeparateCommand) {
        if (template != null && psiElement != null) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            editor.getCaretModel().moveToOffset(psiElement.getTextRange().getStartOffset());
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            template.setToReformat(true);
            TemplateManager.getInstance((Project)project).startTemplate(editor, template, runInSeparateCommand, predefinedVars, null);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunTemplateAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunTemplateAction.$$$reportNull$$$0(1);
        }
        boolean plural = false;
        boolean enabled = false;
        boolean paths = false;
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && FileDocumentManager.getInstance().getFile(editor.getDocument()) != null) {
            enabled = true;
        }
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
        e.getPresentation().setText(this.template.getDescription());
        if (paths) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunTemplateAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        e.getPresentation().setText("Add");
        VirtualFile vf = editor == null ? null : FileDocumentManager.getInstance().getFile(editor.getDocument());
        PsiFile file = PsiManager.getInstance((Project)project).findFile(vf);
        JsonFile jsonFile = (JsonFile)file;
        JsonObject topLevelValue = JsonFacade.getTopLevelObject(jsonFile);
        JsonArray fields = (JsonArray)this.targetFields.getValue();
        JsonElementGenerator json = new JsonElementGenerator(project);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(vf);
        WriteAction.run(() -> {
            if (!fields.getValueList().isEmpty()) {
                PsiElement comma = json.createComma();
                CommandProcessor.getInstance().executeCommand(project, () -> {
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    PsiElement element = (PsiElement)fields.getValueList().get(0);
                    RunTemplateAction.runTemplate(element, editor, this.template, new HashMap<String, String>(), project, false);
                }, "", null);
            } else {
                PsiElement element = fields.getLastChild();
                RunTemplateAction.runTemplate(element, editor, this.template, new HashMap<String, String>(), project, true);
            }
        });
        EditorEx editorex = EditorUtil.getEditorEx((FileEditor)fileEditor);
        if (editorex != null) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
        e.getPresentation().setVisible(false);
    }

    protected Template getTemplate() {
        return this.template;
    }

    protected JsonProperty getTargetFields() {
        return this.targetFields;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/action/RunTemplateAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/action/RunTemplateAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

