/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.service.generator.versionaware;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedNamedElement;
import java.util.Optional;
import org.cxbox.intellij.community.common.util.BcServiceMethodUpdaterUtils;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.bc.service.TemplateProperties;
import org.cxbox.intellij.community.wigdet.bc.service.generator.AbstractBcServicePsiElementGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ElementGenerationContext;
import org.cxbox.intellij.community.wigdet.fields.field.generator.TemplatesKt;

public class VersionAwareBcServiceGenerator
extends AbstractBcServicePsiElementGenerator {
    @Override
    public void setCustomProperties(ElementGenerationContext context) {
        context.properties().setProperty(TemplateProperties.SERVICE_NAME.name(), JavaUtil.capitalizeFirstLetter(context.bcDialogCreationData().serviceClzName()));
        context.properties().setProperty(TemplateProperties.FILE_TEMPLATE_NAME.name(), "PlatformVersionAwareService.java");
        context.properties().setProperty(TemplateProperties.FILE_NAME.name(), context.properties().getProperty(TemplateProperties.SERVICE_NAME.name()) + ".java");
        context.properties().setProperty(TemplateProperties.REPO_NAME_VAR.name(), Optional.ofNullable(context.properties().getProperty(TemplateProperties.REPO_NAME.name())).map(JavaUtil::deCapitalizeFirstLetter).orElse(""));
        context.properties().setProperty(TemplateProperties.PACKAGE_NAME.name(), context.properties().getProperty(TemplateProperties.SERVICE_PACKAGE.name()));
        context.properties().setProperty(TemplateProperties.ENTITY_NAME.name(), Optional.ofNullable(context.elementBcData().entityClz()).map(PsiNamedElement::getName).orElseThrow(() -> new RuntimeException("Cannot find entity name")));
        Optional.ofNullable(context.elementBcData().parentBcEnum()).ifPresent(pbc -> {
            ResponseServiceUtils.ResponseServiceData responseServiceDataByBc = ResponseServiceUtils.getResponseServiceDataByBc(context.module().getProject(), context.module(), pbc);
            context.properties().setProperty(TemplateProperties.PARENT_ENTITY_FQN.name(), Optional.ofNullable(responseServiceDataByBc).map(ResponseServiceUtils.ResponseServiceData::responseServiceEntityPsiClass).map(PsiClass::getQualifiedName).orElse(null));
            context.properties().setProperty(TemplateProperties.PARENT_ENTITY_NAME.name(), Optional.ofNullable(responseServiceDataByBc).map(ResponseServiceUtils.ResponseServiceData::responseServiceEntityPsiClass).map(PsiQualifiedNamedElement::getName).map(JavaUtil::deCapitalizeFirstLetter).orElse(null));
            Optional.ofNullable(context.elementBcData().parentRepoClz()).map(PsiClass::getQualifiedName).ifPresent(fqn -> context.properties().setProperty(TemplateProperties.PARENT_REPO_FQN.name(), (String)fqn));
            context.properties().setProperty(TemplateProperties.SETTER_PARENT_ENTITY.name(), "set" + JavaUtil.capitalizeFirstLetter(context.properties().getProperty(TemplateProperties.PARENT_ENTITY_NAME.name())));
        });
    }

    @Override
    public PsiElement getterElement(ElementGenerationContext context) {
        return context.elementBcData().serviceClz();
    }

    @Override
    public void setterElement(ElementGenerationContext context, PsiElement element) {
        if (!(element instanceof PsiClass)) {
            throw new PlatformValidationException("Generate not available", null, new IllegalStateException("Incorrect element type, expected class, actual: " + String.valueOf(element)), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning);
        }
        PsiClass psiClass = (PsiClass)element;
        context.elementBcData().setServiceClz(psiClass);
    }

    @Override
    public PsiElement updateElement(ElementGenerationContext context) {
        if (context.elementBcData().parentBcEnum() != null) {
            BcServiceMethodUpdaterUtils.updateGetSpecificationOnService(context, sd -> JavaPsiFacade.getElementFactory((Project)context.module().getProject()).createStatementFromText(TemplatesKt.getSpecificationUpdateMethod(sd.isParentBcVersionAware(), sd.bc(), sd.entity(), sd.fieldName()), null), psc -> TemplatesKt.getNewSpecificationMethod(psc.getQualifiedName()));
            BcServiceMethodUpdaterUtils.updateDoCreateEntityInService(context);
            BcServiceMethodUpdaterUtils.updateDoUpdateInService(context);
        }
        return null;
    }
}

