/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.templateHandler;

import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.java.JavaBundle;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class PlatformFilesFromTemplateGroupHandler
implements CreateFromTemplateHandler {
    public static void checkCreate(@NotNull PsiDirectory directory, String name, String ext) throws IncorrectOperationException {
        if (directory == null) {
            PlatformFilesFromTemplateGroupHandler.$$$reportNull$$$0(0);
        }
        PsiUtil.checkIsIdentifier((PsiManager)directory.getManager(), (String)name);
        String fileName = name + "." + ext;
        directory.checkCreateFile(fileName);
    }

    public static boolean canCreate(PsiDirectory dir) {
        return true;
    }

    public JsonFile createFilesFromTemplateGroupHandler(Project project, PsiDirectory directory, String content, boolean reformat) throws IncorrectOperationException {
        String ext = this.getTargetExtensionWithoutLeadingDot();
        String fileName = "myWidget." + ext;
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, (Language)JsonLanguage.INSTANCE, (CharSequence)content, false, false);
        if (!(psiFile instanceof JsonFile)) {
            throw new IncorrectOperationException("This template did not produce a Json file\n" + psiFile.getText());
        }
        JsonFile jsonFile = (JsonFile)psiFile;
        String name = this.getNameFromJsonFile(jsonFile);
        if (name == null) {
            throw new IncorrectOperationException("This template did not produce name tag required for meta files\n" + psiFile.getText());
        }
        PlatformFilesFromTemplateGroupHandler.checkCreate(directory, name, ext);
        jsonFile = (JsonFile)jsonFile.setName(name + "." + ext);
        PsiElement addedElement = directory.add((PsiElement)jsonFile);
        if (addedElement instanceof JsonFile) {
            jsonFile = (JsonFile)addedElement;
            if (reformat) {
                CodeStyleManager.getInstance((Project)project).scheduleReformatWhenSettingsComputed((PsiFile)jsonFile);
            }
            return jsonFile;
        }
        throw new IncorrectOperationException("not json file");
    }

    abstract String getNameFromJsonFile(JsonFile var1);

    @NotNull
    public String getTargetExtensionWithoutLeadingDot() {
        return ".platform";
    }

    public boolean handlesTemplate(@NotNull FileTemplate template) {
        if (template == null) {
            PlatformFilesFromTemplateGroupHandler.$$$reportNull$$$0(1);
        }
        boolean b = (template.getName() + "." + template.getExtension()).endsWith(this.getTargetExtensionWithoutLeadingDot());
        return b;
    }

    @NotNull
    public PsiElement createFromTemplate(@NotNull Project project, @NotNull PsiDirectory directory, String fileName, @NotNull FileTemplate template, @NotNull String templateText, @NotNull Map<String, Object> props) throws IncorrectOperationException {
        if (project == null) {
            PlatformFilesFromTemplateGroupHandler.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            PlatformFilesFromTemplateGroupHandler.$$$reportNull$$$0(3);
        }
        if (template == null) {
            PlatformFilesFromTemplateGroupHandler.$$$reportNull$$$0(4);
        }
        if (templateText == null) {
            PlatformFilesFromTemplateGroupHandler.$$$reportNull$$$0(5);
        }
        if (props == null) {
            PlatformFilesFromTemplateGroupHandler.$$$reportNull$$$0(6);
        }
        JsonFile jsonFile = this.createFilesFromTemplateGroupHandler(project, directory, templateText, template.isReformatCode());
        if (jsonFile == null) {
            PlatformFilesFromTemplateGroupHandler.$$$reportNull$$$0(7);
        }
        return jsonFile;
    }

    public boolean canCreate(PsiDirectory[] dirs) {
        for (PsiDirectory dir : dirs) {
            if (!PlatformFilesFromTemplateGroupHandler.canCreate(dir)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameRequired() {
        return false;
    }

    @NotNull
    public String getErrorMessage() {
        String string = JavaBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]);
        if (string == null) {
            PlatformFilesFromTemplateGroupHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void prepareProperties(@NotNull Map<String, Object> props) {
        if (props == null) {
            PlatformFilesFromTemplateGroupHandler.$$$reportNull$$$0(9);
        }
    }

    @NotNull
    public String commandName(@NotNull FileTemplate template) {
        if (template == null) {
            PlatformFilesFromTemplateGroupHandler.$$$reportNull$$$0(10);
        }
        return "Create Meta from Template";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateText";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/templateHandler/PlatformFilesFromTemplateGroupHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/templateHandler/PlatformFilesFromTemplateGroupHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkCreate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handlesTemplate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFromTemplate";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "commandName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

