/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.commonProps.title;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class FieldTitleInspection
extends LocalInspectionTool {
    public static final String TITLE_DEFAULT_VALUE = "Title Text";

    @NonNls
    @NotNull
    public String getShortName() {
        return "FieldTitleInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            FieldTitleInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            FieldTitleInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile widgetFile = (JsonFile)file;
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        List<Triple<String, JsonObject, JsonArray>> widgetFields = JWidget.getWidgetFields(widgetFile);
        SmartList descriptors = new SmartList();
        widgetFields.forEach(arg_0 -> this.lambda$checkFile$0((List)descriptors, manager, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private String getTitleValueFromKeyOrDefault(JsonObject jsonObject) {
        JsonStringLiteral stringLiteral;
        JsonValue jsonValue;
        JsonProperty keyProperty = jsonObject.findProperty(JWidget.FIELDS_KEY.getName());
        if (keyProperty != null && (jsonValue = keyProperty.getValue()) instanceof JsonStringLiteral && !(stringLiteral = (JsonStringLiteral)jsonValue).getValue().isBlank()) {
            return NameUtil.splitWords((String)stringLiteral.getValue(), (char)' ', word -> word.replaceFirst(String.valueOf(word.charAt(0)), String.valueOf(Strings.toUpperCase((char)word.charAt(0)))));
        }
        return TITLE_DEFAULT_VALUE;
    }

    private /* synthetic */ void lambda$checkFile$0(List descriptors, InspectionManager manager, Triple field) {
        JsonStringLiteral title;
        JsonObject fieldJson = (JsonObject)field.getMiddle();
        JsonProperty fieldTitleProperty = JWidget.getFieldTitleProperty(fieldJson);
        if (fieldTitleProperty != null && ((title = JWidget.getFieldTitle(fieldJson)) == null || title.getValue().isBlank()) && !JWidget.isFieldHidden(fieldJson)) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)fieldTitleProperty, new TextRange(fieldTitleProperty.getText().lastIndexOf(34), fieldTitleProperty.getText().lastIndexOf(34) + 1), "The title cannot be empty", ProblemHighlightType.ERROR, true, new LocalQuickFix[]{new Fix(this.getTitleValueFromKeyOrDefault(fieldJson))}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/title/FieldTitleInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record Fix(String fieldText) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @IntentionName
        @NotNull
        public String getName() {
            return "The title cannot be empty";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (problemDescriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            QuickFixUtils.safeReplaceJsonStringLiteralValueWithText(project, problemDescriptor.getPsiElement().getLastChild(), this.fieldText);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "The title cannot be empty";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "problemDescriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/title/FieldTitleInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

