/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.jetbrains.annotations.NotNull;

public class CoreUtil {
    @NotNull
    public static Optional<PsiClass> findCoreClass(@NotNull String classNameWithoutPlatformPrefix, @NotNull Project project) {
        if (classNameWithoutPlatformPrefix == null) {
            CoreUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CoreUtil.$$$reportNull$$$0(1);
        }
        Optional<PsiClass> optional = Cache.getAllPossiblePlatformRootPackageWithoutDot().stream().map(pkj -> JavaPsiFacade.getInstance((Project)project).findClass(pkj + classNameWithoutPlatformPrefix, GlobalSearchScope.allScope((Project)project))).filter(Objects::nonNull).findFirst();
        if (optional == null) {
            CoreUtil.$$$reportNull$$$0(2);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiType> getCoreAncestorClassGenericByIndex(@NotNull PsiClass psiClass, @NotNull String inheritorsClassFqnWithoutPlatformPrefix, int indexOfGeneric) {
        if (psiClass == null) {
            CoreUtil.$$$reportNull$$$0(3);
        }
        if (inheritorsClassFqnWithoutPlatformPrefix == null) {
            CoreUtil.$$$reportNull$$$0(4);
        }
        Optional<PsiType> optional = Cache.getAllPossiblePlatformRootPackageWithoutDot().stream().map(pkj -> JavaUtil.getClassGenericByIndexFromAncestor(psiClass, pkj + inheritorsClassFqnWithoutPlatformPrefix, indexOfGeneric).orElse(null)).filter(Objects::nonNull).findFirst();
        if (optional == null) {
            CoreUtil.$$$reportNull$$$0(5);
        }
        return optional;
    }

    @NotNull
    public static List<PsiClass> getCoreClassesHasAncestorClassWithDto(@NotNull List<PsiClass> classes, @NotNull String ancestorClassFqnWithoutPlatformPrefix, @NotNull PsiClass dto, int dtoIndexInGeneric) {
        if (classes == null) {
            CoreUtil.$$$reportNull$$$0(6);
        }
        if (ancestorClassFqnWithoutPlatformPrefix == null) {
            CoreUtil.$$$reportNull$$$0(7);
        }
        if (dto == null) {
            CoreUtil.$$$reportNull$$$0(8);
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        Cache.getAllPossiblePlatformRootPackageWithoutDot().forEach(pkj -> result.addAll(classes.stream().filter(Objects::nonNull).filter(clz -> JavaUtil.getClassGenericByIndexFromAncestor(clz, pkj + ancestorClassFqnWithoutPlatformPrefix, dtoIndexInGeneric).stream().anyMatch(psiType -> psiType.getCanonicalText().equals(dto.getQualifiedName()))).toList()));
        ArrayList<PsiClass> arrayList = result;
        if (arrayList == null) {
            CoreUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNameWithoutPlatformPrefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/util/CoreUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritorsClassFqnWithoutPlatformPrefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorClassFqnWithoutPlatformPrefix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dto";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/util/CoreUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findCoreClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoreAncestorClassGenericByIndex";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoreClassesHasAncestorClassWithDto";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findCoreClass";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCoreAncestorClassGenericByIndex";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCoreClassesHasAncestorClassWithDto";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 9 -> new IllegalStateException(string);
        };
    }
}

