/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.CreClassesFqn;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class EnumBcUtil {
    public static List<Pair<String, ? extends LookupElement>> getEnumBcAutocompletion(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(1);
        }
        return EnumBcUtil.getAllEnumBc(project, module).stream().filter(Objects::nonNull).map(e -> Pair.pair((Object)e.getName(), (Object)LookupElementBuilder.createWithIcon((PsiNamedElement)e).withTypeText("enum rest-endpoint", true))).collect(Collectors.toList());
    }

    @NotNull
    public static Optional<PsiEnumConstant> getEnumBc(@Nullable String bc, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(2);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(3);
        }
        if (bc == null) {
            Optional<PsiEnumConstant> optional = Optional.empty();
            if (optional == null) {
                EnumBcUtil.$$$reportNull$$$0(4);
            }
            return optional;
        }
        Optional<PsiEnumConstant> optional = EnumBcUtil.getAllEnumBc(project, module).stream().filter(bcPsi -> bcPsi != null && bc.equals(bcPsi.getName())).findAny();
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(5);
        }
        return optional;
    }

    public static List<PsiEnumConstant> getAllEnumBc(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(6);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(7);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (List)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(EnumBcUtil.getAllEnumBcNoCache(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    private static List<PsiEnumConstant> getAllEnumBcNoCache(@NotNull Module module) {
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(8);
        }
        @NotNull Project project = module.getProject();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
        PsiClass aClass = javaPsiFacade.findClass(Cache.getPlatformRootPackageWithoutDot(project, module) + ".core.crudma.bc.EnumBcIdentifier", scp);
        List<PsiClass> all = aClass != null ? ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scp, (boolean)true).filtering(PsiClass::isEnum).findAll() : Collections.emptyList();
        ArrayList<PsiEnumConstant> codeCompletionsNotFiltered = new ArrayList<PsiEnumConstant>();
        for (PsiClass bcRestController : all) {
            if (bcRestController instanceof ClsClassImpl) {
                ClsClassImpl compiledElement = (ClsClassImpl)bcRestController;
                PsiClass decompiled = compiledElement.getSourceMirrorClass();
                PsiClass psiClass = bcRestController = decompiled != null ? decompiled : bcRestController;
            }
            if (bcRestController == null) continue;
            codeCompletionsNotFiltered.addAll(Arrays.stream(bcRestController.getAllFields()).filter(PsiAdapter::isEnumField).map(PsiEnumConstant.class::cast).toList());
        }
        return codeCompletionsNotFiltered;
    }

    @Nullable
    public static PsiClass getBcServiceClass(@Nullable PsiEnumConstant bcPsiElement, @NotNull Project project, @NotNull Module module) {
        PsiExpressionList argumentList;
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(9);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(10);
        }
        PsiClass bcEnumServiceClass = null;
        if (bcPsiElement != null && (argumentList = bcPsiElement.getArgumentList()) != null) {
            PsiExpression psiExpression;
            PsiExpression[] bcEnumArgs = argumentList.getExpressions();
            PsiClassObjectAccessExpression bcEnumServiceArg = null;
            if (bcEnumArgs.length >= 1 && (psiExpression = bcEnumArgs[bcEnumArgs.length - 1]) instanceof PsiClassObjectAccessExpression) {
                PsiClassObjectAccessExpression expr;
                bcEnumServiceArg = expr = (PsiClassObjectAccessExpression)psiExpression;
            } else if (bcEnumArgs.length >= 2 && (psiExpression = bcEnumArgs[bcEnumArgs.length - 2]) instanceof PsiClassObjectAccessExpression) {
                PsiClassObjectAccessExpression expr;
                bcEnumServiceArg = expr = (PsiClassObjectAccessExpression)psiExpression;
            }
            if (bcEnumServiceArg != null) {
                bcEnumServiceClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)bcEnumServiceArg.getOperand().getType());
            }
        }
        return JavaUtil.getAnyImplementationIfInterfaceOrElseClass(bcEnumServiceClass);
    }

    @Nullable
    public static PsiClass getBcServiceDtoClass(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(11);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(12);
        }
        return ResponseServiceUtils.getResponseServiceDto(bcEnumServiceClass, project, module).orElseGet(() -> EnumBcUtil.getCrudmaDto(bcEnumServiceClass, project, module).orElse(null));
    }

    @Nullable
    public static PsiClass getBcServiceEntityClass(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(13);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(14);
        }
        return ResponseServiceUtils.getResponseServiceEntity(bcEnumServiceClass, project, module).orElse(null);
    }

    public static Optional<PsiClass> getCrudmaDto(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(15);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(16);
        }
        ArrayList<Optional<PsiClass>> candidates = new ArrayList<Optional<PsiClass>>();
        candidates.add(EnumBcUtil.getAllMethodDto(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getOneMethodDto(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getInvokeActionDto(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getUpdateDto(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getDeleteDto(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getPreviewDto(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getCreateDto(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getAllMethodDtoFromReturnStatments(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getOneMethodDtoFromReturnStatments(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getInvokeActionDtoFromReturnStatments(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getUpdateDtoFromReturnStatments(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getDeleteDtoFromReturnStatments(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getPreviewDtoFromReturnStatments(bcEnumServiceClass, project, module));
        candidates.add(EnumBcUtil.getCreateDtoFromReturnStatments(bcEnumServiceClass, project, module));
        return JavaUtil.getMostConcreteInheritorInList(candidates);
    }

    @NotNull
    private static PsiClass getInheritor(PsiClass dtoClass1, PsiClass dtoClass2) {
        PsiClass psiClass = dtoClass1.isInheritor(dtoClass2, true) ? dtoClass1 : dtoClass2;
        if (psiClass == null) {
            EnumBcUtil.$$$reportNull$$$0(17);
        }
        return psiClass;
    }

    @NotNull
    private static Optional<PsiClass> getCreateDto(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(18);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(19);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "create";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(20);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getPreviewDto(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(21);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(22);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "preview";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(23);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getDeleteDto(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(24);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(25);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "delete";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(26);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getUpdateDto(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(27);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(28);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "update";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(29);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getInvokeActionDto(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(30);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(31);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "invokeAction";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(32);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getAllMethodDtoFromReturnStatments(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(33);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(34);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "getAll";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnStatementTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(35);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getUpdateDtoFromReturnStatments(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(36);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(37);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "update";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnStatementTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(38);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getDeleteDtoFromReturnStatments(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(39);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(40);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "delete";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnStatementTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(41);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getPreviewDtoFromReturnStatments(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(42);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(43);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "preview";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnStatementTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(44);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getCreateDtoFromReturnStatments(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(45);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(46);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "create";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnStatementTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(47);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getInvokeActionDtoFromReturnStatments(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(48);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(49);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "invokeAction";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnStatementTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(50);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getOneMethodDtoFromReturnStatments(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(51);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(52);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "get";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnStatementTypeIsDeepInheritorOf(bcEnumServiceClass, project, module, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(53);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getOneMethodDto(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(54);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(55);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "get";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeIsDeepInheritorOf(bcEnumServiceClass, project, module, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(56);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getAllMethodDto(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(57);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(58);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        String methodName = "getAll";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            EnumBcUtil.$$$reportNull$$$0(59);
        }
        return optional;
    }

    @NotNull
    public static Pair<PsiEnumConstant, List<Pair<String, ? extends LookupElement>>> getLinkAndAutocompletionByBc(@Nullable String bc, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(60);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(61);
        }
        return new Pair((Object)EnumBcUtil.getEnumBc(bc, project, module).orElse(null), EnumBcUtil.getEnumBcAutocompletion(project, module));
    }

    @NotNull
    public static Pair<Optional<? extends PsiNamedElement>, List<Pair<String, ? extends LookupElement>>> getLinkAndAutocompletionByFieldNameAndBcName(@NotNull String fieldName, @Nullable String bc, @NotNull Project project, @NotNull Module module) {
        PsiEnumConstant bcPsiElement;
        PsiClass bcEnumServiceClass;
        PsiClass dtoClass;
        if (fieldName == null) {
            EnumBcUtil.$$$reportNull$$$0(62);
        }
        if (project == null) {
            EnumBcUtil.$$$reportNull$$$0(63);
        }
        if (module == null) {
            EnumBcUtil.$$$reportNull$$$0(64);
        }
        if (bc != null && (dtoClass = EnumBcUtil.getBcServiceDtoClass(bcEnumServiceClass = EnumBcUtil.getBcServiceClass(bcPsiElement = (PsiEnumConstant)EnumBcUtil.getLinkAndAutocompletionByBc(bc, project, module).getFirst(), project, module), project, module)) != null) {
            Optional<PsiField> link = Arrays.stream(dtoClass.getAllFields()).filter(f -> f.getName().equalsIgnoreCase(fieldName)).findFirst();
            List completions = Arrays.stream(dtoClass.getAllFields()).filter(e -> !e.getName().equals("errors") && !e.hasAnnotation("com.fasterxml.jackson.annotation.JsonIgnore")).map(e -> Pair.pair((Object)e.getName(), (Object)LookupElementBuilder.createWithIcon((PsiNamedElement)e).withTypeText(e.getType().getPresentableText(), true))).collect(Collectors.toList());
            Pair pair = Pair.pair(link, completions);
            if (pair == null) {
                EnumBcUtil.$$$reportNull$$$0(65);
            }
            return pair;
        }
        Pair pair = Pair.pair(Optional.empty(), List.of());
        if (pair == null) {
            EnumBcUtil.$$$reportNull$$$0(66);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 17, 20, 23, 26, 29, 32, 35, 38, 41, 44, 47, 50, 53, 56, 59, 65, 66 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 58: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 5: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/util/EnumBcUtil";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/util/EnumBcUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumBc";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDto";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewDto";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteDto";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateDto";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvokeActionDto";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodDtoFromReturnStatments";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateDtoFromReturnStatments";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteDtoFromReturnStatments";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewDtoFromReturnStatments";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDtoFromReturnStatments";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvokeActionDtoFromReturnStatments";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getOneMethodDtoFromReturnStatments";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getOneMethodDto";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodDto";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkAndAutocompletionByFieldNameAndBcName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEnumBcAutocompletion";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEnumBc";
                break;
            }
            case 4: 
            case 5: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 65: 
            case 66: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllEnumBc";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllEnumBcNoCache";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBcServiceClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBcServiceDtoClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getBcServiceEntityClass";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCrudmaDto";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDto";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewDto";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDeleteDto";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateDto";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getInvokeActionDto";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethodDtoFromReturnStatments";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateDtoFromReturnStatments";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDeleteDtoFromReturnStatments";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewDtoFromReturnStatments";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDtoFromReturnStatments";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getInvokeActionDtoFromReturnStatments";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getOneMethodDtoFromReturnStatments";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getOneMethodDto";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethodDto";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getLinkAndAutocompletionByBc";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getLinkAndAutocompletionByFieldNameAndBcName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 17, 20, 23, 26, 29, 32, 35, 38, 41, 44, 47, 50, 53, 56, 59, 65, 66 -> new IllegalStateException(string);
        };
    }
}

