/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.type.picklist.pickmap;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.jgoodies.common.base.Strings;
import java.util.Arrays;
import java.util.Objects;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JavaFacade;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.NotNull;

public class PickMapCorrectJavaTypeInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            PickMapCorrectJavaTypeInspection.$$$reportNull$$$0(0);
        }
        if (!((file = holder.getFile()) instanceof JsonFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PickMapCorrectJavaTypeInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        if (!file.getName().endsWith(".widget.json")) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PickMapCorrectJavaTypeInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        final Project project = file.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PickMapCorrectJavaTypeInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        return new JsonElementVisitor(){

            public void visitObject(@NotNull JsonObject o) {
                JsonProperty parentProperty;
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((parentProperty = JsonFacade.getParentOfType((PsiElement)o, JsonProperty.class)) != null && JWidget.FIELDS_PICK_MAP.getName().equals(parentProperty.getName()) && JsonFacade.getParentOfType((PsiElement)JsonFacade.getParentOfType((PsiElement)parentProperty, JsonArray.class), JsonProperty.class) != null) {
                    InspectionManager manager = InspectionManager.getInstance((Project)project);
                    Arrays.stream(o.getChildren()).map(field -> {
                        if (field instanceof JsonProperty) {
                            JsonProperty property = (JsonProperty)field;
                            return property;
                        }
                        return null;
                    }).filter(Objects::nonNull).filter(property -> {
                        String valueAsString = JsonFacade.getValueAsString(property);
                        return !property.getName().isBlank() && valueAsString != null && Strings.isNotBlank((String)JsonFacade.getValueAsString(property)) && !"id".equalsIgnoreCase(property.getName()) && !"id".equalsIgnoreCase(valueAsString);
                    }).filter(property -> PickMapCorrectJavaTypeInspection.this.equalsJavaTypesNameAndValueTypes((JsonProperty)property) == false).forEach(property -> holder.registerProblem(manager.createProblemDescriptor(property.getParent(), property.getTextRangeInParent(), "Java key type and values type do not match", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new QuickFixUtils.ClearJsonPsiLiteralValueAndCallAutocompletionFix("Change the value", (PsiElement)property.getValue())})));
                }
                super.visitObject(o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/cxbox/intellij/community/wigdet/fields/field/type/picklist/pickmap/PickMapCorrectJavaTypeInspection$1", "visitObject"));
            }
        };
    }

    private Boolean equalsJavaTypesNameAndValueTypes(JsonProperty property) {
        if (property.getNameElement().getReferences().length > 0) {
            PsiElement firstResolve = property.getNameElement().getReferences()[0].resolve();
            if (property.getValue() != null && property.getValue().getReferences().length > 0 && firstResolve instanceof PsiField) {
                PsiField firstResolveField = (PsiField)firstResolve;
                PsiElement secondResolve = property.getValue().getReferences()[0].resolve();
                if (secondResolve instanceof PsiField) {
                    PsiField secondResolveField = (PsiField)secondResolve;
                    String firstTextType = this.getTypeFromObjectOrPrimitive(firstResolveField.getType());
                    String secondTextType = this.getTypeFromObjectOrPrimitive(secondResolveField.getType());
                    return Objects.equals(firstTextType, secondTextType);
                }
            }
        }
        return false;
    }

    private String getTypeFromObjectOrPrimitive(PsiType type) {
        return JavaFacade.isPrimitiveType(type.getCanonicalText()) ? JavaFacade.castPrimitiveToObject(type.getCanonicalText()) : type.getCanonicalText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/wigdet/fields/field/type/picklist/pickmap/PickMapCorrectJavaTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/field/type/picklist/pickmap/PickMapCorrectJavaTypeInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

