/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtil {
    public static final String ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_FQN = "java.lang.SuppressWarnings";
    public static final String ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_SHORT = "SuppressWarnings";
    public static final String ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_ATTRIBUTE_NAME = "value";
    public static final String ANNOTATION_AUTOWIRED = "org.springframework.beans.factory.annotation.Autowired";
    public static final String REQUIRED_ARGS_CONSTRUCTOR_FQN = "lombok.RequiredArgsConstructor";
    public static final String REQUIRED_ARGS_CONSTRUCTOR_SHORT = "RequiredArgsConstructor";
    public static final String LOMBOK_GETTER_FQN = "lombok.Getter";

    public static void addSuppressWarningsAnnotationWithNewValue(@NotNull Project project, @NotNull PsiClass clz, @NotNull List<String> valuesToAdd) {
        if (project == null) {
            AnnotationUtil.$$$reportNull$$$0(0);
        }
        if (clz == null) {
            AnnotationUtil.$$$reportNull$$$0(1);
        }
        if (valuesToAdd == null) {
            AnnotationUtil.$$$reportNull$$$0(2);
        }
        PsiElementFactory psiElementFactory = PsiElementFactory.getInstance((Project)project);
        try {
            AnnotationUtil.getNewRequiredArgsConstructorAnnotation(psiElementFactory, AnnotationUtil.getNewValueExpression(clz, valuesToAdd, ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_FQN, ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_ATTRIBUTE_NAME), valuesToAdd).ifPresent(value -> {
                PsiAnnotation oldAnnotation = clz.getAnnotation(ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_FQN);
                if (oldAnnotation != null) {
                    oldAnnotation.delete();
                }
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{clz.getContainingFile()}).run(() -> AnnotationUtil.addAnnotation(project, clz, value));
            });
        }
        catch (Exception e) {
            PlatformValidationException platformValidationException = new PlatformValidationException("Error during update of the VALUE parameter in the SuppressWarnings annotation", (NavigatablePsiElement)clz, project);
            platformValidationException.showPopupWithLinks();
            throw platformValidationException;
        }
    }

    private static boolean containSuppressWarningsValueAllNewValues(@NotNull PsiAnnotation annotation, @NotNull List<String> valuesToAdd) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(3);
        }
        if (valuesToAdd == null) {
            AnnotationUtil.$$$reportNull$$$0(4);
        }
        if (!annotation.hasAttribute(ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_ATTRIBUTE_NAME)) {
            return false;
        }
        PsiAnnotationMemberValue attributeValue = annotation.findAttributeValue(ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_ATTRIBUTE_NAME);
        if (attributeValue != null && attributeValue instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)attributeValue;
            return valuesToAdd.contains(literalExpression.getValue().toString());
        }
        return Optional.ofNullable(annotation.findAttributeValue(ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_ATTRIBUTE_NAME)).stream().map(AnnotationUtil::getValuesFromAnnotation).flatMap(Collection::stream).allMatch(valuesToAdd::contains);
    }

    @Nullable
    public static PsiElement addAnnotation(@NotNull Project project, @NotNull PsiClass clz, @NotNull PsiAnnotation annotation) {
        PsiModifierList modifierList;
        if (project == null) {
            AnnotationUtil.$$$reportNull$$$0(5);
        }
        if (clz == null) {
            AnnotationUtil.$$$reportNull$$$0(6);
        }
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(7);
        }
        if ((modifierList = clz.getModifierList()) != null) {
            if (clz.getAnnotations()[0] != null) {
                PsiElement addedAnnotation = clz.addBefore((PsiElement)annotation, (PsiElement)clz.getAnnotations()[0]);
                CodeStyleManager.getInstance((Project)project).reformat(addedAnnotation);
                return addedAnnotation;
            }
            PsiElement addedAnnotation = clz.addBefore((PsiElement)annotation, (PsiElement)modifierList);
            CodeStyleManager.getInstance((Project)project).reformat(addedAnnotation);
            return addedAnnotation;
        }
        return null;
    }

    private static Optional<PsiAnnotation> getNewRequiredArgsConstructorAnnotation(@NotNull PsiElementFactory psiElementFactory, @NotNull String newValue, @NotNull List<String> valuesToAdd) {
        if (psiElementFactory == null) {
            AnnotationUtil.$$$reportNull$$$0(8);
        }
        if (newValue == null) {
            AnnotationUtil.$$$reportNull$$$0(9);
        }
        if (valuesToAdd == null) {
            AnnotationUtil.$$$reportNull$$$0(10);
        }
        String newAnnotationText = "@" + ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_SHORT + "(" + newValue + ")";
        return Optional.ofNullable(psiElementFactory.createAnnotationFromText(newAnnotationText, null));
    }

    @NotNull
    private static String getLastPartValue(@NotNull List<String> valuesAlreadyAreInAnnotation, @NotNull List<String> newValues) {
        if (valuesAlreadyAreInAnnotation == null) {
            AnnotationUtil.$$$reportNull$$$0(11);
        }
        if (newValues == null) {
            AnnotationUtil.$$$reportNull$$$0(12);
        }
        String string = newValues.stream().filter(newValue -> !valuesAlreadyAreInAnnotation.contains(newValue)).map(value -> "\"" + value + "\"").collect(Collectors.joining(", "));
        if (string == null) {
            AnnotationUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static List<String> getValuesFromAnnotation(@Nullable PsiAnnotationMemberValue value) {
        if (value == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                AnnotationUtil.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (value instanceof PsiArrayInitializerMemberValue) {
            PsiArrayInitializerMemberValue memberValue = (PsiArrayInitializerMemberValue)value;
            List<String> list = Arrays.stream(value.getChildren()).map(child -> {
                PsiLiteralExpression literalExpression;
                return child instanceof PsiLiteralExpression ? (literalExpression = (PsiLiteralExpression)child) : null;
            }).filter(Objects::nonNull).map(literal -> literal.getValue().toString()).toList();
            if (list == null) {
                AnnotationUtil.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<String> list = Arrays.stream(value.getChildren()).map(PsiElement::getText).map(AnnotationUtil::removeSideLugs).toList();
        if (list == null) {
            AnnotationUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    protected static String removeSideLugs(@NotNull String psiElementText) {
        if (psiElementText == null) {
            AnnotationUtil.$$$reportNull$$$0(17);
        }
        if (psiElementText.startsWith("\"")) {
            psiElementText = psiElementText.replaceFirst("\"", "");
        }
        if (psiElementText.endsWith("\"")) {
            psiElementText = psiElementText.substring(0, psiElementText.length() - 1);
        }
        return psiElementText;
    }

    @NotNull
    private static String getNewValueExpression(@NotNull PsiClass aClass, @NotNull List<String> valuesToAdd, @NotNull String annotationFQN, @NotNull String valueName) {
        if (aClass == null) {
            AnnotationUtil.$$$reportNull$$$0(18);
        }
        if (valuesToAdd == null) {
            AnnotationUtil.$$$reportNull$$$0(19);
        }
        if (annotationFQN == null) {
            AnnotationUtil.$$$reportNull$$$0(20);
        }
        if (valueName == null) {
            AnnotationUtil.$$$reportNull$$$0(21);
        }
        PsiAnnotation annotation = aClass.getAnnotation(annotationFQN);
        ArrayList<String> newValues = new ArrayList<String>(valuesToAdd);
        if (annotation != null) {
            newValues.addAll(annotation.hasAttribute(valueName) ? AnnotationUtil.getValuesFromAnnotation(annotation.findAttributeValue(valueName)) : Collections.emptyList());
        }
        String string = (newValues.size() > 1 ? "{" : "") + newValues.stream().distinct().map(value -> "\"" + value + "\"").collect(Collectors.joining(", ")) + (newValues.size() > 1 ? "}" : "");
        if (string == null) {
            AnnotationUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15, 16, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clz";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesToAdd";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementFactory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesAlreadyAreInAnnotation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValues";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/util/AnnotationUtil";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/util/AnnotationUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastPartValue";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesFromAnnotation";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewValueExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSuppressWarningsAnnotationWithNewValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containSuppressWarningsValueAllNewValues";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNewRequiredArgsConstructorAnnotation";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLastPartValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeSideLugs";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getNewValueExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15, 16, 22 -> new IllegalStateException(string);
        };
    }
}

